﻿//////////////////////////////////////////////
// ContentLoadResult.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Script ;
}

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>
#include <NilkinsMemory/Containers/String.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkScripts
{
	enum class CONTENT_LOAD_RESULT_STATE
	{
		SUCCESS = 0,
		PARTIAL,
		FAILURE
	} ;

	template<typename T>
	class ContentLoadResult
	{
		public :

			// Attributs
			nkMemory::BufferCast<nkMemory::String> _errorMessages ;
			nkMemory::BufferCast<T*> _loadResult ;
			CONTENT_LOAD_RESULT_STATE _success = CONTENT_LOAD_RESULT_STATE::SUCCESS ;

		private :

			//ContentLoadResult (const ContentLoadResult&) = delete ;
			//
			//ContentLoadResult& operator= (const ContentLoadResult&) = delete ;
	} ;

	using ContentLoadResultScript = ContentLoadResult<Script> ;
}